
const express = require('express');
const session = require('express-session');
const bodyParser = require('body-parser');
const path = require('path');
require('dotenv').config();

const app = express();

app.use(bodyParser.urlencoded({ extended: false }));
app.use(bodyParser.json());
app.use(session({
  secret: 'cbt_secret',
  resave: false,
  saveUninitialized: true
}));
app.use(express.static(path.join(__dirname, 'public')));
app.set('view engine', 'ejs');

// Routes
app.use('/', require('./routes/auth'));
app.use('/exams', require('./routes/exams'));
app.use('/admin', require('./routes/admin'));

// Default route for cPanel check
app.get('/', (req, res) => {
  res.send('<html><head><title>CBT Platform</title></head><body><h1>Welcome to CBT Platform!</h1></body></html>');
});

const PORT = process.env.PORT || 3000;
app.listen(PORT, () => console.log(`Server running on port ${PORT}`));
