
const express = require('express');
const router = express.Router();
const db = require('../models/db');

router.get('/login', (req, res) => {
  res.render('login');
});

router.post('/login', async (req, res) => {
  const { username, password } = req.body;
  try {
    const [users] = await db.query('SELECT * FROM users WHERE username = ? AND password = ?', [username, password]);
    if (users.length > 0) {
      req.session.user = users[0];
      if (users[0].role === 'admin') return res.redirect('/admin/dashboard');
      return res.redirect('/exams/dashboard');
    }
    res.render('login', { error: 'Invalid credentials' });
  } catch (err) {
    res.send('Database error: ' + err);
  }
});

router.get('/logout', (req, res) => {
  req.session.destroy();
  res.redirect('/login');
});

module.exports = router;
