
const express = require('express');
const router = express.Router();
const db = require('../models/db');

router.get('/', (req, res) => {
  res.redirect('/exams/dashboard');
});

router.get('/dashboard', async (req, res) => {
  if (!req.session.user || req.session.user.role !== 'student') return res.redirect('/login');
  const [exams] = await db.query('SELECT * FROM exams');
  res.render('student_dashboard', { user: req.session.user, exams });
});

router.get('/:id/start', async (req, res) => {
  const [exam] = await db.query('SELECT * FROM exams WHERE id = ?', [req.params.id]);
  const [questions] = await db.query('SELECT * FROM questions WHERE exam_id = ?', [req.params.id]);
  res.render('exam', { exam: exam[0], questions });
});

router.post('/:id/submit', async (req, res) => {
  const answers = req.body;
  const [questions] = await db.query('SELECT * FROM questions WHERE exam_id = ?', [req.params.id]);
  let score = 0;
  const detailed = [];
  questions.forEach(q => {
    const userAnswer = answers[q.id];
    const correct = q.correct_option;
    if (userAnswer === correct) score++;
    detailed.push({ q: q.question_text, correct, userAnswer });
  });
  await db.query('INSERT INTO results (user_id, exam_id, score, detailed_result) VALUES (?, ?, ?, ?)',
    [req.session.user.id, req.params.id, (score/questions.length)*100, JSON.stringify(detailed)]);
  res.redirect('/exams/results');
});

router.get('/results', async (req, res) => {
  const [results] = await db.query('SELECT * FROM results WHERE user_id = ?', [req.session.user.id]);
  res.render('results', { results });
});

module.exports = router;
