
CREATE DATABASE IF NOT EXISTS cbt_db;
USE cbt_db;
CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(255),
    password VARCHAR(255),
    role ENUM('student', 'admin')
);
INSERT INTO users (username, password, role) VALUES ('student', 'student', 'student'), ('admin', 'admin', 'admin');
CREATE TABLE exams (
    id INT AUTO_INCREMENT PRIMARY KEY,
    title VARCHAR(255),
    description TEXT,
    duration INT
);
CREATE TABLE questions (
    id INT AUTO_INCREMENT PRIMARY KEY,
    exam_id INT,
    question_text TEXT,
    option_a VARCHAR(255),
    option_b VARCHAR(255),
    option_c VARCHAR(255),
    option_d VARCHAR(255),
    correct_option ENUM('A', 'B', 'C', 'D')
);
CREATE TABLE results (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT,
    exam_id INT,
    score FLOAT,
    detailed_result JSON,
    submitted_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);
